const express = require('express');
const app = express();
const morgan = require('morgan');
const bodyParser = require('body-parser');
var cors = require('cors');
// const fs = require("fs");
// const https = require('https');
const cookieParser = require("cookie-parser");

app.use(cors());


//routes app-module
const routeUsers = require('./routes/app-module/users');
const routeTransactions = require('./routes/app-module/transactions');
const routeCategories = require('./routes/app-module/categories');
const routeMovimentFixed = require('./routes/app-module/fixed');

app.use(morgan('dev'));
app.use('/uploads',express.static('uploads'));
app.use(bodyParser.urlencoded({extended: true}));
app.use(bodyParser.json()); // apenas formado json e entrada no body
app.use(cookieParser());

app.use(function(req, res, next){
      res.header("User-Agent","node-XMLHttpRequest");
      res.header("Accept", "application/json");
      res.header('Access-Control-Allow-Origin', '*');
      res.header('Access-Control-Allow-Methods', 'GET, POST, PATCH, PUT, DELETE');
      res.header('Access-Control-Allow-Headers', 'content-type');
      res.header('Content-Type', 'application/json');
      res.header('Access-Control-Allow-Credentials', true);
 next();
});




//routes app-module
app.use('/users',routeUsers);
app.use('/transactions',routeTransactions);
app.use('/categories',routeCategories);
app.use('/fixed',routeMovimentFixed);

const whitelist = ['http://localhost:8000', 'http://localhost:8080'];
const corsOptions = {
//   origin: '*',
  origin: function (origin, callback) {
    if (whitelist.indexOf(origin) !== -1) {
      callback(null, true);
    } else {
      callback(null, false);
    }
  },
  methods: ['GET', 'PUT', 'POST', 'DELETE', 'OPTIONS'],
  optionsSuccessStatus: 200,
  credentials: true,
  allowedHeaders: ['Content-Type', 'Authorization', 'X-Requested-With', 'device-remember-token', 'Access-Control-Allow-Origin', 'Origin', 'Accept']
}

app.use(cors(corsOptions));

//para rota nao encontrada
app.use((req,res,next)=>{
 const erro = new Error('Rota Não Encontrada');
 erro.status = 404;
 next(erro);
});

app.use((error,req,res,next)=>{
 res.status(error.status || 500);
 return res.send({
     request:true,  
        success:false,
        message:error.message
 });
});


module.exports = app;