const mysql = require("../../mysql");

exports.getCategoriesIdUser = async (req, res, next) => {
    try{
    const query = `
                    SELECT a.id,a.categoria,a.tipo,a.status, a.paymentFavorite,a.favorite,a.id_usuario,1 as download
                        FROM categorias as a
                        WHERE a.id_usuario = ? AND a.status = 0
                        UNION 
                    SELECT 0,b.categoria,b.tipo,0,'','','',0
                        FROM allCategories as b 
                        where b.categoria not in ( select categoria from categorias where id_usuario = ?)
                    GROUP by b.categoria  
                    ORDER BY categoria ASC` ;
    var result = await mysql.execute(query,[
        req.body.idUser,
        req.body.idUser
        ]);
        const response = {
           request:true,
           success:true,
             length:result.length,
           message: "Sucesso ao buscar a lista de Categorias",
           data: result.map(item =>{
             return {  
             id:item.id ?? 1,  
            idUser:item.id_usuario ?? req.body.idUser, 
            type:item.tipo,
            category:item.categoria,
            download:item.download,
            favorite:item.favorite,
             status:item.status,
            paymentFavorite:item.paymentFavorite
           }
         })
       }
        return res.status(200).send(response);

} catch (error) {
    console.log(error);
    return res.status(500).send({ 
      request:true,
      success:false,
      message: 'Falha ao buscar a lsita de Categorias' 
  });
}
};

exports.getAllCategories = async (req, res, next) => {
    try{
    const query = `
    SELECT * FROM allCategories` ;
    var result = await mysql.execute(query,[
        req.body.idUser
        ]);
        const response = {
           request:true,
           success:true,
             length:result.length,
           message: "Sucesso ao buscar a lista de Categorias",
           data: result.map(item =>{
             return {  
             id:item.id,  
           type:item.tipo,
           category:item.categoria
           }
         })
       }
        return res.status(200).send(response);

} catch (error) {
    console.log(error);
    return res.status(500).send({ 
      request:true,
      success:false,
      message: 'Falha ao buscar a lsitad e Categorias' 
  });
}
};

exports.createCategoryId = async (req, res, next) => {
    try{
    const query = `
    INSERT INTO categorias (id_usuario, tipo, categoria) VALUES (?,?,?)` ;
    var result = await mysql.execute(query,[
        req.body.idUser,
         req.body.type,
          req.body.category
        ]);
        if(result.insertId != null){
          const querySelect = `
                   SELECT a.id,a.categoria,a.tipo,a.status, a.paymentFavorite,a.favorite,a.id_usuario,1 as download
                        FROM categorias as a
                        WHERE a.id_usuario = ? AND a.status = 0
                        UNION 
                    SELECT 0,b.categoria,b.tipo,0,'','','',0
                        FROM allCategories as b 
                        where b.categoria not in ( select categoria from categorias where id_usuario = ?)
                    GROUP by b.categoria  
                    ORDER BY categoria ASC` ;
    var resultSelect = await mysql.execute(querySelect,
        [
        req.body.idUser,
        req.body.idUser
        ]);
          const responseSelect = {
           request:true,
           success:true,
             length:result.length,
           message: "Sucesso ao criar nova categoria",
           data: resultSelect.map(item =>{
             return {  
             id:item.id ?? 1,  
            idUser:item.id_usuario ?? req.body.idUser, 
            type:item.tipo,
            category:item.categoria,
            download:item.download,
            favorite:item.favorite,
            status:item.status,
            paymentFavorite:item.paymentFavorite
           }
         })
       }
        return res.status(200).send(responseSelect);
        }else{
             const responseError = {
           request:true,
           success:false,
            length:result.length,
           message: "Erro ao registrar nova categoria"
       }
        return res.status(200).send(responseError);
            
        }
       

} catch (error) {
    console.log(error);
    return res.status(500).send({ 
      request:true,
      success:false,
      message: 'Falha ao registrar nova categoria' 
  });
}
};

exports.udpateCategory = async (req, res, next) => {
  const column = req.body.column;
  const single = req.body.single;
  const id = req.body.id;
  try {
       const query =  `UPDATE categorias SET ${column} = ?  WHERE id = ?`;
       const result = await mysql.execute(query,[
          single,
          id
      ]);
      if(result.affectedRows > 0){
          const querySelect = `
                   SELECT a.id,a.categoria,a.tipo,a.status, a.paymentFavorite,a.favorite,a.id_usuario,1 as download
                        FROM categorias as a
                        WHERE a.id_usuario = ? AND a.status = 0
                        UNION 
                    SELECT 0,b.categoria,b.tipo,0,'','','',0
                        FROM allCategories as b 
                        where b.categoria not in ( select categoria from categorias where id_usuario = ?)
                    GROUP by b.categoria  
                    ORDER BY categoria ASC` ;
        var resultSelect = await mysql.execute(querySelect,
        [
        req.body.idUser,
        req.body.idUser
        ]);
          const responseSelect = {
           request:true,
           success:true,
             length:result.length,
           message: "Sucesso aao atualizar a categoria",
           data: resultSelect.map(item =>{
             return {  
             id:item.id ?? 1,  
            idUser:item.id_usuario ?? req.body.idUser, 
            type:item.tipo,
            category:item.categoria,
            download:item.download,
            favorite:item.favorite,
            status:item.status,
            paymentFavorite:item.paymentFavorite
           }
         })
       }
        return res.status(200).send(responseSelect);
        }else{
             const responseError = {
           request:true,
           success:false,
            length:result.length,
           message: "Erro ao atualizar a categoria"
       }
        return res.status(200).send(responseError);
            
        }
  } catch (error) {
      return res.status(500).send({
          request:true,
          success:false,
          message: 'Falha ao atualizar usuário',
          error:error
      })
  }
};

exports.updateSingle = async (req,res,next)=>{
    
  const column = req.body.column;
  const single = req.body.single;
  const idUser = req.body.idUser;
  try {
       const query =  `UPDATE appUsers SET ${column} = ?  WHERE id = ?`;
       const result = await mysql.execute(query,[
          single,
          idUser
      ]);
    if(result.affectedRows > 0){
          const querySelect = `
                   SELECT a.id,a.categoria,a.tipo,a.status, a.paymentFavorite,a.favorite,a.id_usuario,1 as download
                        FROM categorias as a
                        WHERE a.id_usuario = ? AND a.status = 0
                        UNION 
                    SELECT 0,b.categoria,b.tipo,0,'','','',0
                        FROM allCategories as b 
                        where b.categoria not in ( select categoria from categorias where id_usuario = ?)
                    GROUP by b.categoria  
                    ORDER BY categoria ASC` ;
        var resultSelect = await mysql.execute(querySelect,
        [
        idUser,
        idUser
        ]);
          const responseSelect = {
           request:true,
           success:true,
             length:result.length,
           message: "Sucesso aao atualizar a categoria",
           data: resultSelect.map(item =>{
             return {  
             id:item.id ?? 1,  
            idUser:item.id_usuario ?? req.body.idUser, 
            type:item.tipo,
            category:item.categoria,
            download:item.download,
            favorite:item.favorite,
            status:item.status,
            paymentFavorite:item.paymentFavorite
           }
         })
       }
        return res.status(400).send(responseSelect);
        }else{
             const responseError = {
           request:true,
           success:false,
            length:result.length,
           message: "Erro ao atualizar a categoria"
       }
      res.status(202).send(response );
        }
  } catch (error) {
      return res.status(500).send({
          request:true,
          success:false,
          message: 'Falha ao atualizar usuário',
          error:error
      })
  }
};

exports.createTypePaymentId = async (req, res, next) => {
    try{
    const query = `
    INSERT INTO typePayment (idUser, typePayment) VALUES (?,?)` ;
    var result = await mysql.execute(query,[
        req.body.idUser,
         req.body.type
        ]);
        if(result.insertId != null){
          const querySelect = `
           SELECT a.id, a.idUser,a.typePayment, 1 as download
                FROM typePayment as a
                WHERE a.idUser = ?
                UNION 
            SELECT 0,0,b.tipo,0
                FROM tipo_pagamento as b 
                 where b.tipo not in ( select typePayment from typePayment where idUser = ? )
            GROUP by b.tipo  
            ORDER BY typePayment ASC` ;
    var resultSelect = await mysql.execute(querySelect,
        [
        req.body.idUser,
        req.body.idUser
        ]);
          const responseSelect = {
           request:true,
           success:true,
             length:result.length,
           message: "Sucesso ao criar novo tipo de pagamento",
           data: resultSelect.map(item =>{
             return {  
            id:item.id == 0? 1:item.id,  
            idUser:item.idUser ?? req.body.idUser, 
            type:item.typePayment,
            download:item.download
           }
         })
       }
        return res.status(200).send(responseSelect);
        }else{
             const responseError = {
           request:true,
           success:false,
            length:result.length,
           message: "Erro ao registrar novo tipo de pagamanto"
       }
        return res.status(200).send(responseError);
            
        }
       

} catch (error) {
    console.log(error);
    return res.status(500).send({ 
      request:true,
      success:false,
      message: 'Falha ao registrar novo tipo de pagamento' 
  });
}
};

exports.getTypePaymentId = async (req, res, next) => {
    try{
    const query = `
           SELECT a.id, a.idUser,a.typePayment, 1 as download
                FROM typePayment as a
                WHERE a.idUser = ?
                UNION 
            SELECT 0,0,b.tipo,0
                FROM tipo_pagamento as b 
                 where b.tipo not in ( select typePayment from typePayment where idUser = ? )
            GROUP by b.tipo  
            ORDER BY typePayment ASC` ;
    var result = await mysql.execute(query,[
        req.body.idUser,
        req.body.idUser
        ]);
        const response = {
           request:true,
           success:true,
             length:result.length,
           message: "Sucesso ao buscar a lista de Tipos de Pagamentos",
           data: result.map(item =>{
             return {  
             id:item.id == 0? 1:item.id,  
            idUser:item.idUser ?? req.body.idUser, 
            type:item.typePayment,
            download:item.download
           }
         })
       }
        return res.status(200).send(response);

} catch (error) {
    console.log(error);
    return res.status(500).send({ 
      request:true,
      success:false,
      message: 'Falha ao buscar a lsita de Tipos de Pagamentos' 
  });
}
};



