const mysql = require("../../mysql");

var admin = require("firebase-admin");

var serviceAccount = require("../../service/painel-gestao-firebase-adminsdk-brf7h-ec66ed1402.json");


exports.createMovimentFixed = async (req, res, next)=>{
        try{
        
        const idUser = req.body.idUser; //id_usuario
        const category = req.body.category;//categoria
        const dueDate = req.body.dueDate; //dia_venc
        const description = req.body.description;//descricao
        const value = req.body.value; //valor
        const obs = req.body.obs; //obs
        const monthYear = req.body.monthYear;//mes_ano
        const status = req.body.status;//status
        const type = req.body.type; //tipo
        const typePayment = req.body.typePayment;//tipo_pagamento
        const insertAutomatic = req.body.insertAutomatic;//data_venc
        const userName = req.body.userName;//responsavel
        const image = req.files['image'] != null? req.files['image'][0].path:null;
        const lat = req.body.lat;
        const lng = req.body.lng;
        
    const query = `
    INSERT INTO despesa_fixa (id_usuario, categoria, dia_venc, descricao, valor, obs, mes_ano, status, tipo, tipo_pagamento, insert_automatic, responsavel,lng, lat,image) 
    VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ` ;
    var result = await mysql.execute(query,[
        idUser,
        category,
        dueDate,
        description,
        value,
        obs,
        monthYear,
        status,
        type,
        typePayment,
        insertAutomatic,
        userName,
        lng,
        lat,
        image
        ]);
        
        if(result.insertId != null){
       const queryGet = ` SELECT * FROM despesa_fixa WHERE id = ?` ;
        var resultGet = await mysql.execute(queryGet,
        [
       result.insertId
        ]);
        const responseGet = {
           request:true,
           success:true,
           message: "Sucesso ao registrar o movimentação fixa" ,
           length:resultGet.length,
           data: resultGet.map(item =>{
             return {  
                    id:item.id, 
                    idUser:item.id_usuario,   
                   description:item.descricao,
                   total:item.valor,
                   type:item.tipo,
                    monthYear:item.mes_ano,
                   category:item.categoria,
                   status:item.status,
                   who:item.responsavel,
                   obs:item.obs,
                   dayVend:item.dia_venc,
                   insertAutomatic:item.insert_automatic,
                   typePayment:item.tipo_pagamento,
                   createdAt:item.created_at,
                  lat:item.lat,
                  lng:item.lng,
          image:item.image
           }
         })
       }
        return res.status(200).send(responseGet);
        }
        else{
       return res.status(400).send({ 
       request:true,
       success:false,
       message: 'Falha ao registrar o movimentação fixa' 
       });
        }


} catch (error) {
    console.log(error);
    return res.status(500).send({ 
      request:true,
      success:false,
      message: 'Falha ao registrar o movimentação fixa' 
  });
}
}

exports.getAllTransactionsFixed = async (req, res, next) => {
    try{
    const query = `
    SELECT * FROM despesa_fixa WHERE id_usuario = ?` ;
    var result = await mysql.execute(query,[
        req.body.idUser
        ]);
        const response = {
           request:true,
           success:true,
           message: "Sucesso ao buscar o buscar todos os lançamentos" ,
           length:result.length,
           data: result.map(item =>{
             return {  
           id:item.id, 
            idUser:item.id_usuario,   
           description:item.descricao,
           total:item.valor,
           type:item.tipo,
            monthYear:item.mes_ano,
           category:item.categoria,
           status:item.status,
           who:item.responsavel,
           obs:item.obs,
           dayVend:item.dia_venc,
           insertAutomatic:item.insert_automatic,
           typePayment:item.tipo_pagamento,
           createdAt:item.created_at,
          lat:item.lat,
          lng:item.lng,
          image:item.image
           }
         })
       }
        return res.status(200).send(response);

} catch (error) {
    console.log(error);
    return res.status(500).send({ 
      request:true,
      success:false,
      message: 'Falha ao buscar todos os lançamentos',
  });
}
}

exports.updateStatusFixed = async (req,res,next)=>{
    
  const column = req.body.column;
  const single = req.body.single;
  const id = req.body.id;
  try {
       const query =  `UPDATE despesa_fixa SET ${column} = ?  WHERE id = ?`;
       const result = await mysql.execute(query,[
          single,
          id
      ]);
      if(result.affectedRows > 0){
         const response ={
             request:true,
             success:true,
              message: "Lançamento atualizado com sucesso",
             
      }
      res.status(202).send(response );  
      }else{
           const response ={
             request:true,
             success:true,
              message: "Erro ao atualizado o lançamento",
             
      }
      res.status(202).send(response );
      }
     
  } catch (error) {
      return res.status(500).send({
          request:true,
          success:false,
          message: 'Falha ao atualizar lançamento',
          error:error
      })
  }
};

exports.updateMovimentFixed = async (req,res,next)=>{
    
  const column = req.body.column;
  const single = req.body.single;
  const id = req.body.id;
  try {
       const query =  `UPDATE despesa_fixa SET ${column} = ?  WHERE id = ?`;
       const result = await mysql.execute(query,[
          single,
          id
      ]);
      if(result.affectedRows > 0){
         const response ={
             request:true,
             success:true,
              message: "Lançamento atualizado com sucesso",
             
      }
      res.status(202).send(response );  
      }else{
           const response ={
             request:true,
             success:true,
              message: "Erro ao atualizado o lançamento",
             
      }
      res.status(202).send(response );
      }
     
  } catch (error) {
      return res.status(500).send({
          request:true,
          success:false,
          message: 'Falha ao atualizar lançamento',
          error:error
      })
  }
};

exports.updateMovimentFixedDuo = async (req,res,next)=>{
    
  const column = req.body.column;
  const single = req.body.single;
  const column2 = req.body.column2;
  const single2 = req.body.single2;
  const id = req.body.id;
  try {
       const query =  `UPDATE despesa_fixa SET ${column} = ?, ${column2} = ?  WHERE id = ?`;
       const result = await mysql.execute(query,[
          single,
          single2,
          id
      ]);
      if(result.affectedRows > 0){
         const response ={
             request:true,
             success:true,
              message: "Lançamento atualizado com sucesso",
             
      }
      res.status(202).send(response );  
      }else{
           const response ={
             request:true,
             success:true,
              message: "Erro ao atualizado o lançamento",
             
      }
      res.status(202).send(response );
      }
     
  } catch (error) {
      return res.status(500).send({
          request:true,
          success:false,
          message: 'Falha ao atualizar lançamento',
          error:error
      })
  }
};

exports.deleteMovimentFixed = async (req,res,next)=>{
    
  const id = req.body.id;
  try {
       const query =  `DELETE FROM despesa_fixa WHERE id = ?`;
       const result = await mysql.execute(query,[
          id
      ]);
      if(result.affectedRows > 0){
         const response ={
             request:true,
             success:true,
              message: "Lançamento excluído com sucesso",
             
      }
      res.status(202).send(response );  
      }else{
           const response ={
             request:true,
             success:true,
              message: "Erro ao excluir o lançamento",
             
      }
      res.status(202).send(response );
      }
     
  } catch (error) {
      return res.status(500).send({
          request:true,
          success:false,
          message: 'Falha ao excluir lançamento',
          error:error
      })
  }
};

function sendMessageHub(lista) {
    const token ='cYpAxJTtTjmh81zfah7pvD:APA91bE8lkgWNZ5IfbryCyLPDdXEIb0-kjGBN7mCEH506Q4yKWu6S4wiTW-nB4sGL7--TBhqmwGT8V4GVwqbJhMaKYVBr2TfekJR9osnIc_T7EjfW2JM_KweNJrjR2FX4q_QQqKLdHLO';
    const title ='Novo Cliente cadastrado para:'+lista[0];
    const bodyMessage ='olá, um novo cliente foi cadastrado na base com nome de: '+lista[1];
    
     var payload = {
        notification: {
          title: title,
          body: bodyMessage,
          badge: ''
        },
        // data:{
        //  dataTitle:req.body.dataTitle,
        //  dataBody:req.body.dataBody,
        //  url:req.body.url
        // },
      };
      var options = {
        priority: "high",
        timeToLive: 60 * 60 *24
      };
   admin.messaging().sendToDevice(token, payload, options).then((response)=> {
    console.log("Successfully sent message:");
 
  })
  .catch(function(error) {
    console.log("Error sending message:", error);
  
  });
}

async function senMessageMultipleHub(list){
    
    const query = `SELECT 
                    tokenFirebase as token
                    FROM appUsers 
                 WHERE id=2 OR id=31
                 `;
      const result = await mysql.execute(query);
      
    if(result.length > 0){
    const registrationTokens = [];
                for (const token of result) {  
                    console.log(token['token']);
                  registrationTokens.push(token['token']);
                }
    const title ='Novo Cliente cadastrado para: '+list[0];
    const bodyMessage ='olá, um novo cliente foi cadastrado na base com nome de: '+list[1];
      var payload = {
         notification: {
          title: title,
          body: bodyMessage,
          badge: ''
        },
      };
      var options = {
        priority: "high",
        timeToLive: 60 * 60 *24
      };
      admin.messaging().sendToDevice(registrationTokens, payload,options)
  .then((response) => {
    console.log("Successfully sent message:");
  }).catch(function(error) {
    console.log("Error sending message:", error);
  });
    }  

}

exports.sendMessageSigleFixed = async (req,res,next) => {
    // var particular ="ds-SfZ36ZkzFvbFWatRJVV:APA91bHx1nRKV1Bv2STVeTYOciWVANINumgRPdn-4ZMsCyKwuSBqRaGWYnpNJIUzBGDJsQO3VxoYRxRxCoZkNPYXzeLXH_rby64tyjfM_bUtyS3_fKl_1S9O4Rg-uFw3sWBV1NtmAmMs";
    // var registrationToken = "f0JItY3PQySzOrx2Ygr6Pt:APA91bGuwihcpUhpjQJYgh9NtjTsr-nwGtrUOc6tpMTAxa4Swvd7h7Rg7WZHZ9K7uyMcDtffOfeYtpLo6uR1gatBdusVnhfWDOapqp_O_IJEB7k_a_w0fzBuossKLl7ATElTAhaljvsr";
    // var tk = 'dvbB8lPVTmSIxBxHaw0GnO:APA91bGqGAc3NiZVhOpB1K2YiVu1SZc8D17sTWCMG4RFmBr5C4xr0oyiWuovdp1zE1mVX3w4DowAND0bmHlZNJuwSZsVV-mnu7QSzEvvmVjx3jTIQrG7u5dRseRq7v-D_FXOc4EIOofb';
    const tokenFirebase ='';
    const title ='';
    const bodyMessage ='';
    
    var token = req.body.token;
     var payload = {
        notification: {
          title: req.body.title,
          body: req.body.body,
          badge: '1',
        },
        // data:{
        //  dataTitle:req.body.dataTitle,
        //  dataBody:req.body.dataBody,
        //  url:req.body.url
        // },
      };
      var options = {
        priority: "high",
        timeToLive: 60 * 60 *24
      };
   admin.messaging().sendToDevice(token, payload, options).then((response)=> {
    console.log("Successfully sent message:", response);
    return res.status(200).send({
        request:true,
        success:true,
        message: 'Sucesso ao enviar sms',
        data:response
    });
  })
  .catch(function(error) {
    console.log("Error sending message:", error);
    return res.status(500).send({
        request:true,
        success:false,
        message: 'Falha ao enviar sms',
        error:response
    });
  });

};

exports.sendMessageMultipleFixed = async (req,res,next)=>{
    //console.log(req.body.tokens);
    // var registrationToken = "f0JItY3PQySzOrx2Ygr6Pt:APA91bGuwihcpUhpjQJYgh9NtjTsr-nwGtrUOc6tpMTAxa4Swvd7h7Rg7WZHZ9K7uyMcDtffOfeYtpLo6uR1gatBdusVnhfWDOapqp_O_IJEB7k_a_w0fzBuossKLl7ATElTAhaljvsr";
    // var tk = 'dvbB8lPVTmSIxBxHaw0GnO:APA91bGqGAc3NiZVhOpB1K2YiVu1SZc8D17sTWCMG4RFmBr5C4xr0oyiWuovdp1zE1mVX3w4DowAND0bmHlZNJuwSZsVV-mnu7QSzEvvmVjx3jTIQrG7u5dRseRq7v-D_FXOc4EIOofb';

    const registrationTokens = req.body.tokens;
    // = [
    //     "f0JItY3PQySzOrx2Ygr6Pt:APA91bGuwihcpUhpjQJYgh9NtjTsr-nwGtrUOc6tpMTAxa4Swvd7h7Rg7WZHZ9K7uyMcDtffOfeYtpLo6uR1gatBdusVnhfWDOapqp_O_IJEB7k_a_w0fzBuossKLl7ATElTAhaljvsr",
    //     'dvbB8lPVTmSIxBxHaw0GnO:APA91bGqGAc3NiZVhOpB1K2YiVu1SZc8D17sTWCMG4RFmBr5C4xr0oyiWuovdp1zE1mVX3w4DowAND0bmHlZNJuwSZsVV-mnu7QSzEvvmVjx3jTIQrG7u5dRseRq7v-D_FXOc4EIOofb'
    //   ];

      var payload = {
         notification: {
          title: req.body.title,
          body: req.body.bodyMessage,
          badge: ''
        },
      data:{
         dataTitle:req.body.dataTitle,
         dataBody:req.body.dataBody,
         url:req.body.url
        },
      };
      var options = {
        priority: "high",
        timeToLive: 60 * 60 *24
      };
      admin.messaging().sendToDevice(registrationTokens, payload,options)
  .then((response) => {
    console.log("Successfully sent message:", response);
    return res.status(200).send({
        request:true,
        success:true,
        message: 'Sucesso ao enviar sms',
    });
  })
  .catch(function(error) {
    console.log("Error sending message:", error);
    return res.status(500).send({
        request:true,
        success:false,
        message: 'Falha ao enviar sms',
    });
  });

};
