const mysql = require("../../mysql");
const bcrypt = require("bcrypt");
const jwt = require("jsonwebtoken");
const nodemailer = require('nodemailer');

var admin = require("firebase-admin");

var serviceAccount = require("../../service/painel-gestao-firebase-adminsdk-brf7h-ec66ed1402.json");

admin.initializeApp({
  credential: admin.credential.cert(serviceAccount),
  databaseURL: "https://painel-gestao.firebaseio.com"
});



let transporter = nodemailer.createTransport({
       host: 'mail.tecnomarketing.net.br',
       port: 465,
       auth: {
           user: "hub5.0@tecnomarketing.net.br",
           pass: "Hub50Sys"
       }
});


async function createMovimentFixed(item){
        try{
        
        const idUser = item.idUser; //id_usuario
        const category = item.category;//categoria
        const dueDate = item.dueDate; //dia_venc
        const description = item.description;//descricao
        const value = item.value; //valor
        const obs = item.obs; //obs
        const monthYear = item.monthYear;//mes_ano
        const status = item.status;//status
        const type = item.type; //tipo
        const typePayment = item.typePayment;//tipo_pagamento
        const insertAutomatic = item.isRegisterAutomatic;//data_venc
        const userName = item.nameUser;//responsavel
        const image = item.image;
        const lat = item.lat;
        const lng = item.lng;
        
    const query = `
    INSERT INTO despesa_fixa (id_usuario, categoria, dia_venc, descricao, valor, obs, mes_ano, status, tipo, tipo_pagamento, insert_automatic, responsavel,lng, lat,image) 
    VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ` ;
    var result = await mysql.execute(query,[
        idUser,
        category,
        dueDate,
        description,
        value,
        obs,
        monthYear,
        status,
        type,
        typePayment,
        insertAutomatic,
        userName,
        lng,
        lat,
        image
        ]);
        
        if(result.insertId != null){
            console.log("Sucesso ao registrar o movimentação fixa" );

        }
        else{
             console.log('Falha ao registrar o movimentação fixa' );

        }


} catch (error) {
    console.log(error);
        console.log('Falha ao registrar o movimentação fixa' );
}
}


exports.headerHome = async (req, res, next) => {
    try{
    const query = `
            SELECT 
                m.month, m.idUser, ifnull(d.despesa,0) as despesa, ifnull(r.receita,0) as receita, (ifnull(r.receita,0)- ifnull(d.despesa,0)) as resultado
                FROM monthYear as m
                LEFT JOIN resumo_mes_despesa as d 
                ON d.id_usuario = m.idUser AND m.month = d.mes_ano
                LEFT JOIN resumo_mes_receita as r
                ON r.id_usuario = m.idUser AND m.month = r.mes_ano
                WHERE idUser =?` ;
    var result = await mysql.execute(query,[
        req.body.id
        ]);
        const response = {
           request:true,
           success:true,
             length:result.length,
           message: "Sucesso ao buscar o resumo de lançamento (tela home header)",
           data: result.map(item =>{
             return {  
           id:item.idUser,      
           month:item.month,
           recipe:item.receita,
           expense:item.despesa,
           balance:item.resultado
           }
         })
       }
        return res.status(200).send(response);

} catch (error) {
    console.log(error);
    return res.status(500).send({ 
      request:true,
      success:false,
      message: 'Falha ao buscar resumo de lançamentos' 
  });
}
};

exports.headerGraphMonthHome = async (req, res, next) => {
    try{
    const query = `SELECT * FROM vw_graph_month WHERE idUser = ?`;
    var result = await mysql.execute(query,[
        req.body.id
        ]);
        const response = {
           request:true,
           success:true,
             length:result.length,
           message: "Sucesso ao buscar o resumo de lançamento (tela home header grapfico mês)",
           data: result.map(item =>{
             return {  
           id:item.idUser,      
           month:item.month,
           recipe:item.input,
           expense:item.output,
           balance:item.balance
           }
         })
       }
        return res.status(200).send(response);

} catch (error) {
    console.log(error);
    return res.status(500).send({ 
      request:true,
      success:false,
      message: 'Falha ao buscar resumo de lançamentos (tela home header grapfico mês)' 
  });
}
};

exports.headerGraphCategoryHome = async (req, res, next) => {
    
    try{
    const query = `SELECT
                        * FROM 
                        resumo_category
                        WHERE 
                        mes_ano = ?
                        AND
                        tipo_lanc ='Despesa'
                        AND
                        id_usuario = ?
                        GROUP BY id_usuario,categoria
                        ORDER BY total DESC
                        LIMIT 5;`;
    var result = await mysql.execute(query,[
        req.body.month,
        req.body.id
        ]);
        const response = {
           request:true,
           success:true,
             length:result.length,
           message: "Sucesso ao buscar o resumo de lançamento (tela home header grapfico linear categorias)",
           data: result.map(item =>{
             return {  
           id:item.id_usuario,      
           category:item.categoria,
           month:item.mes_ano,
           value:item.total,
           type:item.tipo_lanc,
           valueMax:item.valueMax
           }
         })
       }
        return res.status(200).send(response);

} catch (error) {
    console.log(error);
    return res.status(500).send({ 
      request:true,
      success:false,
      message: 'Falha ao buscar resumo de lançamentos (tela home header grapfico linear categorias)' 
  });
}
};

exports.summaryCategory = async (req, res, next) => {
    try{
    const query = `
    SELECT * FROM resumo_category WHERE id_usuario = ?` ;
    var result = await mysql.execute(query,[
        req.body.id
        ]);
        const response = {
           request:true,
           success:true,
           message: "Sucesso ao buscar o resumo das categorias",
               length:result.length,
           data: result.map(item =>{
             return {  
           id:item.id_usuario,      
           month:item.mes_ano,
           category:item.categoria,
           type:item.tipo_lanc,
           total:item.total
           }
         })
       }
        return res.status(200).send(response);

} catch (error) {
    console.log(error);
    return res.status(500).send({ 
      request:true,
      statusCode:400,
      success:false,
      message: 'Falha ao buscar resumo das categorias' 
  });
}
};

exports.getCategoryMonthYear = async (req, res, next) => {
    try{
    const query = `
    SELECT * FROM lancamentos WHERE
                  id_usuario = ?
                  AND tipo_lanc = 'Despesa'
                  AND mes_ano_venc = ?
                  AND categoria = ?` ;
    var result = await mysql.execute(query,[
        req.body.idUser,
          req.body.monthYear,
            req.body.category
        ]);
        const response = {
           request:true,
           success:true,
           message: "Sucesso ao buscar o resumo da categoria: " + req.body.category,
               length:result.length,
           data: result.map(item =>{
             return {  
           id:item.id, 
            idUser:item.id_usuario,   
           description:item.descricao,
           total:item.valor,
           type:item.tipo_lanc,
           category:item.categoria,
           status:item.status_lanc,
           who:item.responsavel,
           obs:item.obs,
           dateLanc:item.data_lanc,
           dateVenc:item.data_venc,
            monthYearLanc:item.mes_ano_lanc,
             monthYearDue:item.mes_ano_venc,
              typePayment:item.tipo_pagamento,
               createdAt:item.created_at,
           }
         })
       }
        return res.status(200).send(response);

} catch (error) {
    console.log(error);
    return res.status(500).send({ 
      request:true,
      success:false,
      message: 'Falha ao buscar resumo da categoria' + req.body.category,
  });
}
};

exports.summaryPayment = async (req, res, next) => {
    try{
    const query = `
    SELECT * FROM resumo_pagamento WHERE id_usuario = ?` ;
    var result = await mysql.execute(query,[
        req.body.id
        ]);
        const response = {
           request:true,
           success:true,
           message: "Sucesso ao buscar o resumo por tipo de pagamento",
               length:result.length,
           data: result.map(item =>{
             return {  
           id:item.id_usuario,      
           month:item.mes_ano,
           paymentType:item.pagamento,
           type:item.tipo_lanc,
           total:item.total
           }
         })
       }
        return res.status(200).send(response);

} catch (error) {
    console.log(error);
    return res.status(500).send({ 
      request:true,
      statusCode:400,
      success:false,
      message: 'Falha ao buscar resumo por tipo de pagamento' 
  });
}
};

exports.getAllTransactions = async (req, res, next) => {
    try{
    const query = `
    SELECT * FROM lancamentos WHERE
                  id_usuario = ? AND mes_ano_venc = ?` ;
    var result = await mysql.execute(query,[
        req.body.idUser,
        req.body.monthYear,
        ]);
        const response = {
           request:true,
           success:true,
           message: "Sucesso ao buscar o buscar todos os lançamentos" ,
           length:result.length,
           data: result.map(item =>{
             return {  
           id:item.id, 
            idUser:item.id_usuario,   
           description:item.descricao,
           total:item.valor,
           type:item.tipo_lanc,
           category:item.categoria,
           status:item.status_lanc,
           who:item.responsavel,
           obs:item.obs,
           dateLanc:item.data_lanc,
           dateVenc:item.data_venc,
         monthYearLanc:item.mes_ano_lanc,
          monthYearDue:item.mes_ano_venc,
         typePayment:item.tipo_pagamento,
         createdAt:item.created_at,
         image : item.image,
         lat: item.lat,
         lng: item.lng,
         remember: item.remember
           }
         })
       }
        return res.status(200).send(response);

} catch (error) {
    console.log(error);
    return res.status(500).send({ 
      request:true,
      success:false,
      message: 'Falha ao buscar todos os lançamentos',
  });
}
};

exports.getAllTransactionsId = async (req, res, next) => {
    try{
    const query = `
    SELECT * FROM lancamentos WHERE  id=?` ;
    var result = await mysql.execute(query,[
        req.body.id
        ]);
        if(result.length > 0){
        var  item = result[0];
        const response = {
           request:true,
           success:true,
           message: "Sucesso ao buscar o buscar o lançamento" ,
           length:result.length,
           data:{  
           id:item.id, 
            idUser:item.id_usuario,   
           description:item.descricao,
           total:item.valor,
           type:item.tipo_lanc,
           category:item.categoria,
           status:item.status_lanc,
           who:item.responsavel,
           obs:item.obs,
           dateLanc:item.data_lanc,
           dateVenc:item.data_venc,
         monthYearLanc:item.mes_ano_lanc,
          monthYearDue:item.mes_ano_venc,
         typePayment:item.tipo_pagamento,
         createdAt:item.created_at,
         image : item.image,
         lat: item.lat,
         lng: item.lng,
         remember: item.remember
           }
       }
        return res.status(200).send(response);
        }else{
       return res.status(500).send({ 
       request:true,
       success:false,
       message: 'Não foi encontrado orçamento com esse identificador',
        });
        }

} catch (error) {
    console.log(error);
    return res.status(500).send({ 
      request:true,
      success:false,
      message: 'Falha ao buscar todos os lançamentos',
  });
}
};

exports.getAllTransactionsFixed = async (req, res, next) => {
    try{
    const query = `
    SELECT * FROM despesa_fixa WHERE id_usuario = ?` ;
    var result = await mysql.execute(query,[
        req.body.idUser
        ]);
        const response = {
           request:true,
           success:true,
           message: "Sucesso ao buscar o buscar todos os lançamentos" ,
           length:result.length,
           data: result.map(item =>{
             return {  
           id:item.id, 
            idUser:item.id_usuario,   
           description:item.descricao,
           total:item.valor,
           type:item.tipo,
            monthYear:item.mes_ano,
           category:item.categoria,
           status:item.status,
           who:item.responsavel,
           obs:item.obs,
           dayVend:item.dia_venc,
           insertAutomatic:item.insert_automatic,
         typePayment:item.tipo_pagamento,
         createdAt:item.created_at
           }
         })
       }
        return res.status(200).send(response);

} catch (error) {
    console.log(error);
    return res.status(500).send({ 
      request:true,
      success:false,
      message: 'Falha ao buscar todos os lançamentos',
  });
}
};

exports.getPaymentType = async (req, res, next) => {
    try{
    const query = `
    SELECT * FROM typePayment WHERE idUser = ?` ;
    var result = await mysql.execute(query,[
        req.body.idUser
        ]);
        const response = {
           request:true,
           success:true,
           message: "Sucesso ao buscar o buscar tipos de pagamento" ,
           length:result.length,
           data: result.map(item =>{
             return {  
           id:item.id, 
          idUser:item.idUser,   
           typePayment:item.typePayment
           }
         })
       }
        return res.status(200).send(response);

} catch (error) {
    console.log(error);
    return res.status(500).send({ 
      request:true,
      success:false,
      message: 'Falha ao buscar tipos de pagamento',
  });
}
};

exports.createTransaction = async (req, res, next) => {
    
    try{
        
        const idUser = req.body.idUser; //id_usuario
        const typePayment = req.body.typePayment;//tipo_pagamento
        const value = req.body.value; //valor
        const dateLanc = req.body.dateLanc; //data_lanc
        const dateVenc = req.body.dateVenc;//data_venc
        const type = req.body.type; //tipo_lanc
        const monthYearLanc = req.body.monthYearLanc; //mes_ano_lanc
        const monthYearVenc = req.body.monthYearVenc;//mes_ano_venc
        const category = req.body.category;//categoria
        const status = req.body.status;//status_lanc
        const description = req.body.description;//descricao
        const obs = req.body.obs;
        const nameUser = req.body.nameUser;//responsavel
        //new inf
        const image = req.files['image'] != null? req.files['image'][0].path:null;
        const lat = req.body.lat;
        const lng = req.body.lng;
        const remember = req.body.remember;   
        const fixedExpense = req.body.fixedExpense;
        const isRegisterAutomatic = req.body.isRegisterAutomatic;
        const dueDate=req.body.dueDate;
        const item = {
                 idUser : idUser, 
                 typePayment : typePayment,
                 value : value,
                 dueDate:dueDate,
                 dateLanc : dateLanc,
                 dateVenc : dateVenc,
                 type : type,
                 monthYearLanc : monthYearLanc,
                 monthYear : monthYearVenc,
                 category : category,
                 status : status,
                 description : description,
                 obs : req.body.obs,
                 nameUser : req.body.nameUser,
                 image : image,
                 lat :lat,
                 lng :lng,
                 remember : remember,
                 isRegisterAutomatic:isRegisterAutomatic
        };
        
    const query = `
    INSERT INTO lancamentos (descricao,valor,tipo_lanc,categoria,status_lanc,responsavel,obs,data_lanc,data_venc,mes_ano_lanc,
    mes_ano_venc,id_usuario,tipo_pagamento,remember,lng,lat,image) 
    VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ` ;
    var result = await mysql.execute(query,[
        description,
        value,
        type,
        category,
        status,
        nameUser,
        obs,
        dateLanc,
        dateVenc,
        monthYearLanc,
        monthYearVenc,
        idUser,
        typePayment,
        remember,
        lng,
        lat,
        image
        ]);
        
        if(result.insertId != null){
        if(fixedExpense == 1){
        createMovimentFixed(item);
        }
       const queryGet = ` SELECT * FROM lancamentos WHERE id_usuario = ? AND mes_ano_venc = ?` ;
       var resultGet = await mysql.execute(queryGet,
        [
        idUser,
        monthYearVenc,
        ]);
        
        const responseGet = {
           request:true,
           success:true,
           message: "Sucesso ao registrar o lançamento" ,
           length:resultGet.length,
           data: resultGet.map(item =>{
             return {  
           id:item.id, 
            idUser:item.id_usuario,   
           description:item.descricao,
           total:item.valor,
           type:item.tipo_lanc,
           category:item.categoria,
           status:item.status_lanc,
           who:item.responsavel,
           obs:item.obs,
           dateLanc:item.data_lanc,
           dateVenc:item.data_venc,
         monthYearLanc:item.mes_ano_lanc,
          monthYearDue:item.mes_ano_venc,
         typePayment:item.tipo_pagamento,
         createdAt:item.created_at,
         image : item.image,
         lat: item.lat,
         lng: item.lng,
         remember: item.remember
           }
         })
       }
        return res.status(200).send(responseGet);
        }
        else{
       return res.status(400).send({ 
       request:true,
       success:false,
       message: 'Falha ao registrar o lançamento financeiro' 
       });
        }


} catch (error) {
    console.log(error);
    return res.status(500).send({ 
      request:true,
      success:false,
      message: 'Falha ao registrar o lançamento financeiro' 
  });
}
};


exports.updateStatus = async (req,res,next)=>{
    
  const column = req.body.column;
  const single = req.body.single;
  const id = req.body.id;
  try {
       const query =  `UPDATE lancamentos SET ${column} = ?  WHERE id = ?`;
       const result = await mysql.execute(query,[
          single,
          id
      ]);
      if(result.affectedRows > 0){
         const response ={
             request:true,
             success:true,
              message: "Lançamento atualizado com sucesso",
             
      }
      res.status(202).send(response );  
      }else{
           const response ={
             request:true,
             success:true,
              message: "Erro ao atualizado o lançamento",
             
      }
      res.status(202).send(response );
      }
     
  } catch (error) {
      return res.status(500).send({
          request:true,
          success:false,
          message: 'Falha ao atualizar lançamento',
          error:error
      })
  }
};


exports.updateMoviment = async (req,res,next)=>{
    
  const column = req.body.column;
  const single = req.body.single;
  const id = req.body.id;
  try {
       const query =  `UPDATE lancamentos SET ${column} = ?  WHERE id = ?`;
       const result = await mysql.execute(query,[
          single,
          id
      ]);
      if(result.affectedRows > 0){
         const response ={
             request:true,
             success:true,
              message: "Lançamento atualizado com sucesso",
             
      }
      res.status(202).send(response );  
      }else{
           const response ={
             request:true,
             success:true,
              message: "Erro ao atualizado o lançamento",
             
      }
      res.status(202).send(response );
      }
     
  } catch (error) {
      return res.status(500).send({
          request:true,
          success:false,
          message: 'Falha ao atualizar lançamento',
          error:error
      })
  }
};

exports.updateMovimentDuo = async (req,res,next)=>{
    
  const column = req.body.column;
  const single = req.body.single;
  const column2 = req.body.column2;
  const single2 = req.body.single2;
  const id = req.body.id;
  try {
       const query =  `UPDATE lancamentos SET ${column} = ?, ${column2} = ?  WHERE id = ?`;
       const result = await mysql.execute(query,[
          single,
          single2,
          id
      ]);
      if(result.affectedRows > 0){
         const response ={
             request:true,
             success:true,
              message: "Lançamento atualizado com sucesso",
             
      }
      res.status(202).send(response );  
      }else{
           const response ={
             request:true,
             success:true,
              message: "Erro ao atualizado o lançamento",
             
      }
      res.status(202).send(response );
      }
     
  } catch (error) {
      return res.status(500).send({
          request:true,
          success:false,
          message: 'Falha ao atualizar lançamento',
          error:error
      })
  }
};

exports.deleteTransaction = async (req,res,next)=>{
    
  const id = req.body.id;
  try {
       const query =  `DELETE FROM lancamentos WHERE id = ?`;
       const result = await mysql.execute(query,[
          id
      ]);
      if(result.affectedRows > 0){
         const response ={
             request:true,
             success:true,
              message: "Lançamento excluído com sucesso",
             
      }
      res.status(202).send(response );  
      }else{
           const response ={
             request:true,
             success:true,
              message: "Erro ao excluir o lançamento",
             
      }
      res.status(202).send(response );
      }
     
  } catch (error) {
      return res.status(500).send({
          request:true,
          success:false,
          message: 'Falha ao excluir lançamento',
          error:error
      })
  }
};


function sendMessageHub(lista) {
    const token ='cYpAxJTtTjmh81zfah7pvD:APA91bE8lkgWNZ5IfbryCyLPDdXEIb0-kjGBN7mCEH506Q4yKWu6S4wiTW-nB4sGL7--TBhqmwGT8V4GVwqbJhMaKYVBr2TfekJR9osnIc_T7EjfW2JM_KweNJrjR2FX4q_QQqKLdHLO';
    const title ='Novo Cliente cadastrado para:'+lista[0];
    const bodyMessage ='olá, um novo cliente foi cadastrado na base com nome de: '+lista[1];
    
     var payload = {
        notification: {
          title: title,
          body: bodyMessage,
          badge: ''
        },
      
      };
      var options = {
        priority: "high",
        timeToLive: 60 * 60 *24
      };
   admin.messaging().sendToDevice(token, payload, options).then((response)=> {
    console.log("Successfully sent message:");
 
  })
  .catch(function(error) {
    console.log("Error sending message:", error);
  
  });
}



async function senMessageMultipleHub(list){
    
    const query = `SELECT 
                    tokenFirebase as token
                    FROM appUsers 
                 WHERE id=2 OR id=31
                 `;
      const result = await mysql.execute(query);
      
    if(result.length > 0){
    const registrationTokens = [];
                for (const token of result) {  
                    console.log(token['token']);
                  registrationTokens.push(token['token']);
                }
    const title ='Novo Cliente cadastrado para: '+list[0];
    const bodyMessage ='olá, um novo cliente foi cadastrado na base com nome de: '+list[1];
      var payload = {
         notification: {
          title: title,
          body: bodyMessage,
          badge: ''
        },
      };
      var options = {
        priority: "high",
        timeToLive: 60 * 60 *24
      };
      admin.messaging().sendToDevice(registrationTokens, payload,options)
  .then((response) => {
    console.log("Successfully sent message:");
  }).catch(function(error) {
    console.log("Error sending message:", error);
  });
    }  

}




async function registerMessage(payload,payment,response) {
     
        // console.log("Successfully sent message:", response);
        // console.log(response['results'][0]['messageId']);
        // console.log(response['successCount']);
        // console.log(response['successCount'] > 0);
    if(response['successCount'] > 0){
        
         const query =  `INSERT INTO message(userId, title, body, subTitle, messageId, idMessage, dataBody, subBody, url, type, status) VALUES (?,?,?,?,?,?,?,?,?,?,?)`;
         const result = await mysql.execute(query,[
           payment.userId,
           payload['notification']['title'],
           payload['notification']['body'],
           '',
            response['results'][0]['messageId'],
           payment.idMoviment,
           '',
           '',
           '',
           1,
           '0'
           ]);
        
     return {
        request:true,
        success:false,
        message: 'Registro de sms na base com sucesso!'
       
     }
    }else{
         return {
        request:true,
        success:false,
        message: 'Falha ao registrar sms na base ',
    };
}
}


exports.sendMessageDayPayment = async (req,res,next) => {
    
  try{
       const query =  `SELECT * FROM dayPayment`;
       const result = await mysql.execute(query);
          
   
  if(result.length > 0){
    for(const payment of result.values()){
         const queryMessage =  `SELECT * FROM message WHERE userId =? AND status = 0`;
        const resultMessage = await mysql.execute(queryMessage,[
            payment.userId
            ]);
    var token = payment.token;
    var badge = Number(resultMessage.length + 1).toString();
    console.log('badge: '+badge);
    var title ='Informe Controle Financeiro';
    var body ='Olá, ' + payment.name + ', Você tem um lançamento de ' + payment.typeOperation + ' da categoria: ' + payment.category +
    ', com vencimento na data de hoje dia ' + payment.dayPayment + ', no valor de: ' 
    + Number(payment.value).toLocaleString('pt-br',{style: 'currency', currency: 'BRL'}) + ', acesse o app Controle Financeiro e atualize seus lançamentos...';
 
    var payload = {
        notification: {
          title: title,
          body: body,
          badge:badge
        },
          data:{
         idMessage:payment.idMoviment.toString(),
        },
      };
      var options = {
        priority: "high",
        timeToLive: 60 * 60 *24
      };
      
      
   admin.messaging().sendToDevice(token, payload, options).then((response)=> {
       registerMessage(payload,payment,response);
  }).catch(function(error) {
    console.log("Error sending message:", error);
    return res.status(500).send({
        request:true,
        success:false,
        message: 'Falha ao enviar sms',
        error:response
    });
  });
      
         
  }
  return res.status(200).send({
        request:true,
        success:true,
        message: 'Sucesso ao enviar sms',
        length:result.length
    });
      }else{
        return res.status(200).send({
        request:true,
        success:true,
        message: 'Não tem lançamentos vencendo hoje para envio de sms',
        length:result.length
      });
}
      
 
      
      
  }catch (error) {
      console.log(error);
      return res.status(500).send({
          request:true,
          success:false,
          message: 'Falha ao enviar sms',
          error:error
      })
  }


};



exports.sendMessageSigle = async (req,res,next) => {
    
    // var particular ="ds-SfZ36ZkzFvbFWatRJVV:APA91bHx1nRKV1Bv2STVeTYOciWVANINumgRPdn-4ZMsCyKwuSBqRaGWYnpNJIUzBGDJsQO3VxoYRxRxCoZkNPYXzeLXH_rby64tyjfM_bUtyS3_fKl_1S9O4Rg-uFw3sWBV1NtmAmMs";
    // var registrationToken = "f0JItY3PQySzOrx2Ygr6Pt:APA91bGuwihcpUhpjQJYgh9NtjTsr-nwGtrUOc6tpMTAxa4Swvd7h7Rg7WZHZ9K7uyMcDtffOfeYtpLo6uR1gatBdusVnhfWDOapqp_O_IJEB7k_a_w0fzBuossKLl7ATElTAhaljvsr";
    // var tk = 'dvbB8lPVTmSIxBxHaw0GnO:APA91bGqGAc3NiZVhOpB1K2YiVu1SZc8D17sTWCMG4RFmBr5C4xr0oyiWuovdp1zE1mVX3w4DowAND0bmHlZNJuwSZsVV-mnu7QSzEvvmVjx3jTIQrG7u5dRseRq7v-D_FXOc4EIOofb';
    const tokenFirebase ='';
    const title ='';
    const bodyMessage ='';
    
    var token = req.body.token;
     var payload = {
        notification: {
          title: req.body.title,
          body: req.body.body,
        //   badge: '1',
        },
       
        data:{
          idMessage:'34972'
        },
      };
      var options = {
        priority: "high",
        timeToLive: 60 * 60 *24
      };
   admin.messaging().sendToDevice(token, payload, options).then((response)=> {
    console.log("Successfully sent message:", response);
    return res.status(200).send({
        request:true,
        success:true,
        message: 'Sucesso ao enviar sms',
        data:response
    });
  })
  .catch(function(error) {
    console.log("Error sending message:", error);
    return res.status(500).send({
        request:true,
        success:false,
        message: 'Falha ao enviar sms',
        error:response
    });
  });

};

exports.sendMessageMultiple = async (req,res,next)=>{
    //console.log(req.body.tokens);
    // var registrationToken = "f0JItY3PQySzOrx2Ygr6Pt:APA91bGuwihcpUhpjQJYgh9NtjTsr-nwGtrUOc6tpMTAxa4Swvd7h7Rg7WZHZ9K7uyMcDtffOfeYtpLo6uR1gatBdusVnhfWDOapqp_O_IJEB7k_a_w0fzBuossKLl7ATElTAhaljvsr";
    // var tk = 'dvbB8lPVTmSIxBxHaw0GnO:APA91bGqGAc3NiZVhOpB1K2YiVu1SZc8D17sTWCMG4RFmBr5C4xr0oyiWuovdp1zE1mVX3w4DowAND0bmHlZNJuwSZsVV-mnu7QSzEvvmVjx3jTIQrG7u5dRseRq7v-D_FXOc4EIOofb';

    const registrationTokens = req.body.tokens;
    // = [
    //     "f0JItY3PQySzOrx2Ygr6Pt:APA91bGuwihcpUhpjQJYgh9NtjTsr-nwGtrUOc6tpMTAxa4Swvd7h7Rg7WZHZ9K7uyMcDtffOfeYtpLo6uR1gatBdusVnhfWDOapqp_O_IJEB7k_a_w0fzBuossKLl7ATElTAhaljvsr",
    //     'dvbB8lPVTmSIxBxHaw0GnO:APA91bGqGAc3NiZVhOpB1K2YiVu1SZc8D17sTWCMG4RFmBr5C4xr0oyiWuovdp1zE1mVX3w4DowAND0bmHlZNJuwSZsVV-mnu7QSzEvvmVjx3jTIQrG7u5dRseRq7v-D_FXOc4EIOofb'
    //   ];

      var payload = {
         notification: {
          title: req.body.title,
          body: req.body.bodyMessage,
          badge: ''
        },
      data:{
         dataTitle:req.body.dataTitle,
         dataBody:req.body.dataBody,
         url:req.body.url
        },
      };
      var options = {
        priority: "high",
        timeToLive: 60 * 60 *24
      };
      admin.messaging().sendToDevice(registrationTokens, payload,options)
  .then((response) => {
    console.log("Successfully sent message:", response);
    return res.status(200).send({
        request:true,
        success:true,
        message: 'Sucesso ao enviar sms',
    });
  })
  .catch(function(error) {
    console.log("Error sending message:", error);
    return res.status(500).send({
        request:true,
        success:false,
        message: 'Falha ao enviar sms',
    });
  });

};


exports.getMessageId = async (req,res,next)=>{
    const userId = req.body.userId;
  try {
       const query =  `SELECT * FROM message WHERE userId = ?`;
       const result = await mysql.execute(query,[
          userId
      ]);
      if(result.length > 0){
         const response ={
             request:true,
             success:true,
             message: "Sucesso o buscar as mensagens",
             length:result.length,
             data: result.map(item =>{
             return {  
              id:item.id, 
              userId:item.userId,
               title:item.title,
                body:item.body,
                 subTitle:item.subTitle,
                  messageId:item.messageId,
                   idMessage:item.idMessage,
                    dataBody:item.dataBody,
                     subBody:item.subBody,
                      url:item.url,
                       type:item.type,
                        status:item.status,
                         createdAt:item.createdAt
             }
            })
              
             
      }
        res.status(202).send(response );  
  
      }else{
           const response ={
             request:true,
             success:true,
              message: "Erro ao buscar o lista de mensagens",
              length:result.length,
              data:[]
             
      }
      res.status(202).send(response );
      }
     
  } catch (error) {
      console.log(error);
      return res.status(500).send({
          request:true,
          success:false,
          message: 'Falha ao buscar as mensagens',
          error:error
      })
  }
};

exports.updateMessage = async (req,res,next)=>{
    
  const status = req.body.status;
  const id = req.body.id;
  try {
       const query =  `UPDATE message SET status = ?  WHERE id = ?`;
       const result = await mysql.execute(query,[
           status,
          id
      ]);
      if(result.affectedRows > 0){
         const response ={
             request:true,
             success:true,
              message: "Mensagem atualizada com sucesso",
             
      }
      res.status(202).send(response );  
      }else{
           const response ={
             request:true,
             success:true,
              message: "Erro ao atualizado o mensagem",
             
      }
      res.status(202).send(response );
      }
     
  } catch (error) {
      return res.status(500).send({
          request:true,
          success:false,
          message: 'Falha ao atualizar mensagem',
          error:error
      })
  }
};

exports.deleteMessage = async (req,res,next)=>{
  const id = req.body.id;
  try {
       const query =  `DELETE FROM message WHERE id = ?`;
       const result = await mysql.execute(query,[
          id
      ]);
      if(result.affectedRows > 0){
         const response ={
             request:true,
             success:true,
              message: "Lançamento atualizado com sucesso",
             
      }
      res.status(202).send(response );  
      }else{
           const response ={
             request:true,
             success:true,
              message: "Erro ao atualizado o lançamento",
             
      }
      res.status(202).send(response );
      }
     
  } catch (error) {
      return res.status(500).send({
          request:true,
          success:false,
          message: 'Falha ao atualizar lançamento',
          error:error
      })
  }
};



















   







