const mysql = require("../../mysql");
const bcrypt = require("bcrypt");
const jwt = require("jsonwebtoken");
const nodemailer = require('nodemailer');

let transporter = nodemailer.createTransport({
       host: 'mail.tecnomarketing.net.br',
       port: 465,
       auth: {
           user: "hub5.0@tecnomarketing.net.br",
           pass: "Hub50Sys"
       }
});

exports.createUser = async (req, res, next) => {
  try {
    const query = 'SELECT * FROM users WHERE email = ?';
    const result = await mysql.execute(query, [req.body.email]);
    if (result.length > 0) {
      return res.status(409).send({ 
              request:true,
        success:false,
        message: "Já existe um usuário cadastrado com o email: " + req.body.email 
      });
    }else{
        
        
    
    const hash = await bcrypt.hashSync(req.body.password, 10);
    const queryCreated = "INSERT INTO users (name, cpf, email, phone, password, status, typeUser, codeVersion, nameGroup, tokenFirebase) VALUES (?,?,?,?,?,?,?,?,?,?)";
    const results = await mysql.execute(queryCreated,
      [
       req.body.name,
       req.body.cpf,
       req.body.email,
       req.body.phone,
       hash,
       req.body.status,
       '0',
       req.body.codeVersion,
       req.body.nameGroup,
       req.body.tokenFirebase
      ]);

      if(results.insertId !== null){
      const response = {
      request:true,
        success:true,
        message: "Usuario criado com sucesso",
        data: {
        id: results.insertId
      },
    };

    return res.status(201).send(response);  
      }else{
       const response = {
         request:true,
        success:false,
        message: "Não foi possível registrar o usuário, tente novamente mais tarde, ou contate o administrador do sistema.",
        data: {
        id: results.insertId
      },
    };
    return res.status(500).send(response);  
      }
         
        
        
    }

  } catch (error) {
      console.log(error);
    return res.status(500).send({ 
          request:true,
      success:false,
      message: 'Falha ao registrar usuário',
      

    });
  }
};

// exports.login = async (req, res, next) => {
//     try{
//     const query = `
//     SELECT * FROM users WHERE email = ?` ;
//     var result = await mysql.execute(query,[
//         req.body.email
//         ]);

//     if (result.length < 1) {
//          console.log(req.body.email);
//         return res.status(400).send({ 
//               request:true,
//           success:false,
//           message: 'Os dados informados do e-mail ou senha está inválido.'})
//     }
//     if (result[0].situacao == 0) {
     
//         return res.status(401).send({ 
//               request:true,
//           success:false,
//           message: 'Seu acesso ao sistema está bloqueado '+ result[0].situacao})
//     }
//     var user = result[0];
//     if(user.typeSystem == 0){
//         //   const hash = await bcrypt.hash(req.body.password,PASSWORD_BCRYPT);
//         //   console.log('hanh: ' + hash);
//           console.log('passorwd: '+user.password);
//         const resultCompare = await bcrypt.compare(user.password,req.body.password);
//           console.log('comparacao:'+resultCompare);
//          const response = {
//           request:true,
//           success:true,
//           message: "Usuário autenticado com sucesso",
//           data: {
//           token:token,       
//           id: user.id,
//           conta:user.conta,
//           base:user.base,
//           urlImage: user.caminhoFoto,
//           email: user.email,
//           name:user.name,
//           phone:user.phone,
//           status:user.situacao,
//           typeUser:user.tipoUser,
//           tokenFirebase:user.token,
//           codeVersion:user.versionCod,
//          },
//       };
//         return res.status(200).send(response);
//     }
//     if (await bcrypt.compareSync(req.body.password, user.pass)) {
//         const token = jwt.sign({
//             userId: user.id,
//             email: user.email
//         },
//         process.env.JWT_KEY,
//         {
//             expiresIn: "30d"
//         });
     
//         const response = {
//           request:true,
//           success:true,
//           message: "Usuário autenticado com sucesso",
//           data: {
//           token:token,       
//           id: user.id,
//           conta:user.conta,
//           base:user.base,
//           urlImage: user.caminhoFoto,
//           email: user.email,
//           name:user.name,
//           phone:user.phone,
//           status:user.situacao,
//           typeUser:user.tipoUser,
//           tokenFirebase:user.token,
//           codeVersion:user.versionCod,
//          },
//       };
//         return res.status(200).send(response);
//     }else{
//          console.log(req.body.email);
//          return res.status(401).send({ 
//               request:true,
//         success:false,
//         message: 'Falha na autenticação' 
//     })
//     }
    

// } catch (error) {
//     console.log(error);
//     return res.status(500).send({ 
//           request:true,
//       success:false,
//       message: 'Falha na autenticação' 
//   });
// }
// };

exports.login = async (req, res, next) => {
    try{
    const query = `
    SELECT * FROM users WHERE email = ?` ;
    var result = await mysql.execute(query,[
        req.body.email
        ]);

    if (result.length < 1) {
         
        return res.status(400).send({ 
              request:true,
          success:false,
          message: 'Os dados informados do e-mail ou senha está inválido.'})
    }
    if (result[0].situacao == 0) {
  
        return res.status(401).send({ 
              request:true,
          success:false,
          message: 'Seu acesso ao sistema está bloqueado '+ result[0].situacao})
    }
    var user = result[0];
    if (await bcrypt.compareSync(req.body.password, user.pass)) {
        const token = jwt.sign({
            userId: user.id,
            email: user.email
        },
        process.env.JWT_KEY,
        {
            expiresIn: "30d"
        });
     
        const response = {
          request:true,
          success:true,
          message: "Usuário autenticado com sucesso!",
          data: {
          token:token,       
          id: user.id,
          conta:user.conta,
          base:user.base,
          urlImage: user.caminhoFoto,
          email: user.email,
          name:user.name,
          phone:user.phone,
          status:user.situacao,
          typeUser:user.tipoUser,
          tokenFirebase:user.token,
          codeVersion:user.versionCod,
         },
      };
        return res.status(200).send(response);
    }else{
      
         return res.status(401).send({ 
              request:true,
        success:false,
        message: 'Falha na autenticação' 
    })
    }
    

} catch (error) {
    console.log(error);
    return res.status(500).send({ 
          request:true,
      success:false,
      message: 'Falha na autenticação' 
  });
}
};
//functions finalizadas

exports.getTokenSms = async (req, res, next) => {
    try{
    const query = `
    SELECT id, tipoUser, token, conta FROM users WHERE situacao ='1' AND token IS NOT NULL`;
    var result = await mysql.execute(query);

    if (result.length > 0) {
            const response = {
           request:true,
            success:true,
            message: 'Sucesso ao buscar a lista de tokens dos Usuários',
            data:result.map(user =>{
            return {
               id: user.id,
               tipoUser:user.tipoUser,
               token:user.token,
               conta: user.conta
          }
         })
       }
      return res.status(200).send(response); 
          
    }else{
         return res.status(401).send({ 
          statusCode:400,
          success:false,
          message: 'Não foi encontrado token'})
    }

  

} catch (error) {
    console.log(error);
    return res.status(500).send({ 
      request:true,
      success:false,
      message: 'Falha ao buscar a lista de tokens' 
  });
}
};

exports.updateTypeUser = async (req,res,next)=>{
  try {
      const query =  `UPDATE users SET typeUser = ?  WHERE id = ?`;
      const result = await mysql.execute(query,[
          req.body.typeUser,
          req.body.id
      ]);
      if(result.affectedRows > 0){
          const response ={
              request:true,
             success:true,
              message: "Usuário atualizado com sucesso",
             
      }
      res.status(202).send(response );
      }else{
          const response ={
             request:true,
             success:false,
              message: "Não houve alteraçaão de dados",
             
      }
      res.status(400).send(response );
      }
      
  } catch (error) {
      return res.status(500).send({
          request:true,
          success:false,
          message: 'Falha ao atualizar usuário',
          error:error
      })
  }
};


exports.updateToken = async (req,res,next)=>{
  try {
     const querySelect = `SELECT * FROM users WHERE id = ?`;
     const resultSelect = await mysql.execute(querySelect,[req.body.id]);
     if(resultSelect[0].situacao == 1){
          const query =  `UPDATE users SET token=?, version_code=? WHERE id=?`;
         const result = await mysql.execute(query,
         [
          req.body.tokenFirebase,
          req.body.codeVersion,
          req.body.id
      ]);
      if(result.affectedRows > 0){
           const response ={
             request:true,
             success:true,
              message: "Token atualizado com sucesso"
      }
       res.status(202).send(response );
      }else{
           const response ={
             request:true,
             success:false,
              message: "O Token não foi atualizado"
      }
       res.status(400).send(response );
      }
     
     }else{
         const response ={
          
                 request:true,
             success:false,
              message: "Seu acesso ao sistema está bloqueado"
      }
      res.status(202).send(response ); 
     }
    
  } catch (error) {
      return res.status(500).send({
          statusCode:400,
              request:true,
          success:false,
          message: 'Falha ao atualizar usuário',
          error:error
      })
  }
};

exports.updateSingle = async (req,res,next)=>{
  const column = req.body.column;
  const single = req.body.single;
  const idUser = req.body.id;
  try {
       const query =  `UPDATE users SET ${column} = ?  WHERE id = ?`;
       const result = await mysql.execute(query,[
          single,
          idUser
      ]);
      if(result.affectedRows > 0){
              const response ={
             request:true,
             success:true,
              message: "Usuário atualizado com sucesso",
             
      }
      res.status(202).send(response );
      }else{
              const response ={
             request:true,
             success:false,
              message: "Não houve atualização de dados",
             
      }
      res.status(400).send(response );
      }
  
  } catch (error) {
      return res.status(500).send({
           request:true,
          success:false,
          message: 'Falha ao atualizar usuário',
          error:error
      })
  }
};

exports.updatePassword = async (req,res,next)=>{
  const password = await bcrypt.hashSync(req.body.password, 10);
  const email = req.body.email;

  try {
       const query =  `UPDATE users SET pass = ?  WHERE email = ?`;
       const result = await mysql.execute(query,[
          password,
          email
      ]);
      if(result.affectedRows > 0){
          const response ={
           request:true,
             success:true,
              message: "A senha foi alterada com sucesso",
             
      }
      res.status(202).send(response );
      }else{
          const response ={
           request:true,
             success:false,
              message: "A senha não foi alterada, alguma informação esta incorreta",
             
      }
      res.status(401).send(response);
      }
      
  } catch (error) {
      return res.status(500).send({
        request:true,
          success:false,
          message: 'Falha ao alterar a senha!',
          error:error
      })
  }
};

exports.createOrUpdateAddress = async (req, res, next) => {
  try {
    const query = 'SELECT * FROM address WHERE idUser = ?';
    const result = await mysql.execute(query, [req.body.id]);
    
    if (result.length > 0) {
        const queryUpdate = `
        UPDATE address SET 
                street =?,
                number=?,
                neighborhood=?,
                city=?,
                state=?,
                zipeCode=  ?,
                stateAbbreviation= ?
        WHERE idUser = ? `;
        const resultUpdate = await mysql.execute(queryUpdate,
      [
       req.body.street,
       req.body.number,
       req.body.neighborhood,
       req.body.city,
       req.body.state,
       req.body.zipeCode,
       req.body.stateAbbreviation,
       req.body.id,
      ]);
      if(resultUpdate.affectedRows > 0){
          return res.status(201).send({ 
        request:true,
        success:true,
        message: "Endereço atualizado com Sucesso!" 
      }); 
      }else{
           return res.status(201).send({ 
        request:true,
        success:false,
        message: "Erro ao atualizar o Endereço" 
      });
      }
     
    }
    
    
    const queryCreated = "INSERT INTO address (idUser, street, number, neighborhood, city, state, zipeCode, stateAbbreviation) VALUES (?,?,?,?,?,?,?,?)";
    const results = await mysql.execute(queryCreated,
      [
       req.body.id,
       req.body.street,
       req.body.number,
       req.body.neighborhood,
       req.body.city,
       req.body.state,
       req.body.zipeCode,
       req.body.stateAbbreviation
      ]);
      if(results.length > 0){
            const response = {
       request:true,
        success:true,
        message: "Endereço cadastrado com sucesso",
        data: {
        id: results.insertId
      },
    };
    return res.status(201).send(response);
      }else{
       const response = {
       request:true,
        success:false,
        message: "Falha ao cadastrado o endereço",
     
    };
    return res.status(201).send(response);
      }
   
    

  } catch (error) {
    return res.status(500).send({ 
      request:true,
      success:false,
      message: 'Falha ao registrar endereço',

    });
  }
};


exports.resetPassword = async (req, res, next) => {
  try {
    const query = 'SELECT * FROM users WHERE id =?';
    const result = await mysql.execute(query, 
       [
        req.body.id
        ]);
    
    if (result.length > 0) 
    {
     return res.status(201).send({ 
         statusCode:200,
        success:true,
        message: "Confirmado o cadastro do CPF e Telefone",
        data:{
            id:result[0].id
             }
      });
     
    }
    else 
    {
        const response = {
        request:true,
        success:false,
        message: "Os dados informados não conferem com o cadastro!",
    };
    return res.status(201).send(response);
        
    }
    
    

  } catch (error) {
    
    return res.status(500).send({ 
     request:true,
      success:false,
      message: 'Falha ao verificar numero do telefone e cpf',
      

    });
  }
};

exports.updateResetPassword = async (req,res,next)=>{

  const password = await bcrypt.hashSync(req.body.password, 10);
  const id = req.body.id;
  
  try {
       const query =  `UPDATE users SET password = ?  WHERE id = ?`;
       const result = await mysql.execute(query,[
          password,
          id
      ]);
      if(result.affectedRows > 0){
         const response ={
           request:true,
             success:true,
              message: "A nova senha foi criada com sucesso",
             
      }
      res.status(202).send(response ); 
      }else{
          const response ={
           request:true,
             success:false,
              message: "Falha ao atualizar a senha",
             
      }
      res.status(202).send(response );
      }
      
  } catch (error) {
      return res.status(500).send({
          request:true,
          success:false,
          message: 'Falha ao criar nova senha!',
          error:error
      })
  }
};


exports.getUrlAppStores = async (req,res,next)=>{
  try {
      const response ={
            statusCode:200,
               request:true,
             success:true,
             message: "Busca de URL Apps com sucesso",
             data:{
                 googleStore:'https://play.google.com/store/apps/details?id=com.painelgestao.app_brprotecoes',
                 appleStopre:'https://apps.apple.com/br/app/br-protecoes/id1617150113'
             }
             
      }
      res.status(202).send(response );
  } catch (error) {
      return res.status(500).send({
          request:true,
          success:false,
          message: 'Falha ao buscar url das lojas de aplicativos!',
          error:error
      })
  }
};


exports.excludeUserId = async (req,res,next)=>{
     const timeElapsed = Date.now();
     const today = new Date(timeElapsed);
      var date =  today.toISOString();
//   var date = Date.now();
    // var date = new Date().toLocaleDateString();
   const cpf = req.body.cpf;
   const idUser = req.body.idUser;
   const exlude = req.body.idUser+'/'+req.body.cpf+'/'+date;

  try {
       const query =  `UPDATE appUsers SET status =?, excludeUserId=?, cpf=? WHERE cpf = ? AND id =?`;
       const result = await mysql.execute(query,
       [
          0,
          exlude,
          '00000000000',//64748145005
          cpf,
          idUser
      ]);
      if(result.affectedRows > 0){
          const response ={
            statusCode:200,
              success:true,
              message: "A conta e seus dados foram excluídos com sucesso!",
             
      }
        res.status(202).send(response );
      }else{
          const responseError ={
            statusCode:400,
             success:false,
             message: 'Falha ao excluir os dados da conta, tente novamente mais tarde ou contate o administrador do sistema!',
             
      }
       res.status(500).send(responseError );
      }
      
      
   
  } catch (error) {
      return res.status(500).send({
          statusCode:400,
          success:false,
          message: 'Falha ao excluir os dados da conta, tente novamente mais tarde ou contate o administrador do sistema!',
          error:error
      })
  }
};

exports.registerUser = async (req, res, next) => {

  try {
      var cpf = req.body.cpf;
      const elementoAlvo = cpf
      const cpfAtual = cpf.value   
      let cpfAtualizado;
      cpfAtualizado = cpf.replace(/(\d{3})(\d{3})(\d{3})(\d{2})/, 
      function( regex, argumento1, argumento2, argumento3, argumento4 ) {
        return argumento1 + '.' + argumento2 + '.' + argumento3 + '-' + argumento4;
     });  
    //  elementoAlvo.value = cpfAtualizado; 
     
     var name = req.body.name;
     var code1 = Math.floor(Math.random() * (999 - 111 + 1) + 111);
     var code2 = Math.floor(Math.random() * (999 - 111 + 1) + 111);
     var n1 = name.charAt(0);
     var n2 = name.charAt(2);
     var code = n1 +code1 + n2 + code2;
     var password = code.toUpperCase();
     
    const query = 'SELECT * FROM appUsers WHERE cpf = ?';
    const result = await mysql.execute(query, [req.body.cpf]);
    if (result.length > 0) {
      return res.status(409).send({
        statusCode:400,
        success:false,
        message: "Já existe um usuário cadastrado com o cpf: " + req.body.cpf 
      });
    }else{
        
     const hash = await bcrypt.hashSync(password, 10);
    const queryCreated = "INSERT INTO appUsers (name, cpf, email, phone, password, status, typeUser,isVendor, isMaster) VALUES (?,?,?,?,?,?,?,?,?)";
    const results = await mysql.execute(queryCreated,
      [
       req.body.name,
       req.body.cpf,
       req.body.email,
       req.body.phone,
       hash,
       req.body.status,
       req.body.typeUser,
       req.body.isVendor,
       req.body.isMaster
       
      ]);

    message = {
        from: "HUB 5.0 <hub5.0@tecnomarketing.net.br>",
        to:req.body.name + '<' + req.body.email + '>',
        subject:'Cadastro HUB 5.0 Group',
        text: 'SISTEMA HUB 5.O Group',
        html:
        `
        <!DOCTYPE html>
            <html lang="pt-BR">
            <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <title>Time right now:</title>
            </head>
            <body>
                  <div style='width: 100%; height:100;
                  text-align:center; border:0px;
                  color:#274457; background:#274457;'>
                  <table>
                
                   <td><div 
                   align='center'
                   >
                     <font face='verdana'
                     color='#ffffff'
                     size=+3
                     >  HUB 5.0 </font>
                     <br>
                   </div>
                   </td>
                   </table>
                   </div>
                    <br>
            <b><font face='Georgia' size=+1> Olá, ${name}. </font></b><br> <br />
           <font-family:'verdana'> Recebemos sua solicitação de cadastro para acesso ao sistema de HUB 5.0 Group.</font><br><br>
            <font-family:'verdana'>Para validarmos o acesso o acesso no aplicativo com segurança, use a senha provisória abaixo:</font><br><br>
           <b><font-family:'verdana'>Faça acesso com seu CPF de cadastro: <ont-family:'verdana' size=+2>${cpfAtualizado}</fonf> e a sua senha provisória é: <ont-family:'verdana' size=+2> ${password}</font></font></b><br><br>
           <font-family:'verdana'>Importante lembrar: por segurança essa senha deve ser alterada no seu primeiro acesso, acesse a aba perfil e em altera senha, faça a troca da sua senha!<br><br>
            Se você não solicitou o cadastro, desconsidere esse e-mail.<br><br>
           Obrigado por nos ajudar a manter sua conta segura.<br>
           Equipe Sistema Tecno Marketing.<br><br>
           <div align='left
                     <font face='Georgia'
                     color='#027FFE'
                     size=+1'>
                     dicas:<br> 
                     <ul>
                          <li>Aprender a controlar seu orçamento é o modo mais prático de cortar gastos e começar a investir.</li>
                          <li>Jamais gaste seu dinheiro antes de você possuí-lo.</li>
                          <li>Para o sucesso, atitude é igualmente tão importante quanto capacidade.</li>
                          <li>Sucesso é a soma de pequenos esforços, repetidos o tempo todo.</li>
                          <li>Planejamento, organização e motivação são fatores essenciais para a prosperidade.</li>
                          <li>Motivação é aquilo que te faz começar. Hábito é aquilo que te faz continuar.</li>
                          <li>Nós somos aquilo que fazemos repetidamente. Excelência, então, não é um modo de agir, mas um hábito.</li>
                          <li>Cuidado com as pequenas despesas. Um pequeno vazamento afundará um grande navio.</li>
                        </ul>
                     </font><br>
                    <div align='left
                     <font face='Georgia'
                     color='#027FFE'
                     size=+1'>
                     Contato: sistemas@tecnomarketing.com.br 
                     </font><br><br>
          <div style='width: 100%;
           height:40;
           text-align:center;
           border:0px;
           color:#F7E94A;
           background:#027FFE;' >
       </html>
       `,

   };
   
       const response = {
       request:true,
        success:true,
        message: "Usuário criado com sucesso",
        data: {
        //id: results.insertId
      },
    }
    
       
    transporter.sendMail(message, function(err, info) {
        if (err) {
          console.log(err)
          return res.status(500).send({
           request:true,
            success:false,
            message: 'Falha ao enviar Email com a senha',
        });
        } else {
          console.log(info);
          return res.status(200).send(response);
        }
    });
   
    };

  } catch (error) {
    console.log(error);  
    return res.status(500).send({ 
     request:true,
      success:false,
      message: 'Falha ao registrar usuário',

    });
  }
};

exports.getAllUsers = async (req, res, next) => {
    try{
     const query = `SELECT * FROM users`;
     const result = await mysql.execute(query);
     
     if(result.length > 0){
         
            const response = {
           statusCode:200,
            success:true,
            message: 'Sucesso ao buscar a lista de Usuários',
             data:result.map(user =>{
            return {
               id: user.id,
               isMaster:user.isMaster,
               isVendor:user.isVendor,
               email: user.email,
               name:user.name,
               phone:user.phone,
               cpf:user.cpf,
               status:user.status,
               typeUser:user.typeUser,
               codeVersion:user.codeVersion   
                
          }
         })
       }
      return res.status(200).send(response); 
         
     }else{
            const response = {
           request:true,
            success:true,
            message: 'A lista de Usuários está vazia',
            data:{}
         }
        return res.status(200).send(response);    
        } 
     }catch (error) {
      return res.status(500).send({
     statusCode:400,
          success:false,
          message: 'Falha ao buscar os dados dos usuários',
          error:error
      })
  }
};


exports.validatelogin = async (req, res, next) => {
    try{
    const query = `
    SELECT *
    FROM users
    WHERE id = ? AND situacao = 1`
    ;
    var result = await mysql.execute(query,[req.body.id]);

    if (result.length < 1) {
        return res.status(401).send({ 
          request:true,
          success:false,
          message: 'Usuário Bloqueado!'}
          )
    }
    else
    {
     return res.status(200).send({ 
          request:true,
          success:true,
          message: 'Usuário Ativo!'}
          )
}

} catch (error) {
    console.log(error);
    return res.status(500).send({ 
      request:true,
      success:false,
      message: 'Falha na autenticação' 
  });
}

};
