const jwt = require('jsonwebtoken');
require('dotenv').config();

exports.mandatory = (req, res, next) => {
    

    try {
        const token = req.headers.authorization.split(' ')[1];
        const decode = jwt.verify(token, process.env.JWT_KEY);
        req.user = decode;
         next();
    } catch (error) {
        return res.status(401).send({ 
        request:false,        
        success:false,
        message: 'Falha na autenticação' });
    }

}

exports.mandatoryAdm = (req, res, next) => {

    try {
        const token = req.headers.authorization.split(' ')[1];
        const decode = jwt.verify(token, process.env.JWT_KEY_ADM);
        req.user = decode;
         next();
    } catch (error) {
        return res.status(401).send({ 
        request:false,        
        success:false,
        message: 'Falha na autenticação' });
    }

}

exports.optional = (req, res, next) => {

    try {
        const token = req.headers.authorization.split(' ')[1];
        const decode = jwt.verify(token, process.env.JWT_KEY);
        req.user = decode;
        next();
    } catch (error) {
        next();
    }

}