const mysql = require('mysql');
require('dotenv').config()

var pool = mysql.createPool({
    "connectionLimit": 1000,
    "user": process.env.MYSQL_USER,
    "password": process.env.MYSQL_PASSWORD,
    "database": process.env.MYSQL_DATABASE,
    "host": process.env.MYSQL_HOST,
    "port": process.env.MYSQL_PORT,
    debug:false
});

exports.execute = (query, params=[]) => {
    return new Promise((resolve, reject) => {
        pool.query(query, params, (error, result, fields) => {
            if (error) {
                reject(error);
                //  pool.end();
            } else {
                 
                 resolve(result);
               
                 
            }
        });
    })
}

exports.close = () =>{
   console.log(pool);
    console.log('---------------------------------------------');
  pool.end();  
  console.log(pool);
}


exports.pool = pool;

