const express = require('express');
const router = express.Router();
const multer = require('multer');
const FixedController = require('../../controllers/app-module/fixed-controller');
const login = require('../../middleware/login');


const storage = multer.diskStorage({
    destination: function (req, file, cb) {
        cb(null,'./uploads/');
    },
    filename: function (req, file, cb) {
      cb(null, Date.now() + file.originalname.trim());
    }
  });

const upload = multer({
    storage:storage,
});


const cpUpload = upload.fields([{ name: 'image', maxCount: 1 }, { name: 'imgPdf', maxCount: 1 }]);


router.post('/getAllTransactionsFixed',login.mandatory,FixedController.getAllTransactionsFixed);
router.post('/createMovimentFixed',login.mandatory,cpUpload,FixedController.createMovimentFixed);
router.post('/updateStatusFixed',login.mandatory,FixedController.updateStatusFixed);
router.post('/updateMovimentFixed',login.mandatory,FixedController.updateMovimentFixed);
router.post('/deleteMovimentFixed',login.mandatory,FixedController.deleteMovimentFixed);
router.post('/updateMovimentFixedDuo',login.mandatory,FixedController.updateMovimentFixedDuo);
router.post('/sendMessageSigleFixed',FixedController.sendMessageSigleFixed);
router.post('/sendMessageMultipleFixed',FixedController.sendMessageMultipleFixed);


module.exports = router;