const express = require('express');
const router = express.Router();
const multer = require('multer');
const TransactionsController = require('../../controllers/app-module/transactions-controller');
const login = require('../../middleware/login');


const storage = multer.diskStorage({
    destination: function (req, file, cb) {
        cb(null,'./uploads/');
    },
    filename: function (req, file, cb) {
      cb(null, Date.now() + file.originalname.trim());
    }
  });

const upload = multer({
    storage:storage,
});


const cpUpload = upload.fields([{ name: 'image', maxCount: 1 }, { name: 'imgPdf', maxCount: 1 }]);

router.post('/headerHome',login.mandatory,TransactionsController.headerHome);
router.post('/headerGraphMonthHome',login.mandatory,TransactionsController.headerGraphMonthHome);
router.post('/headerGraphCategoryHome',login.mandatory,TransactionsController.headerGraphCategoryHome);
router.post('/summaryCategory',login.mandatory,TransactionsController.summaryCategory);
router.post('/summaryPayment',login.mandatory,TransactionsController.summaryPayment);
router.post('/getCategoryMonthYear',login.mandatory,TransactionsController.getCategoryMonthYear);
router.post('/getAllTransactions',login.mandatory,TransactionsController.getAllTransactions);
router.post('/getAllTransactionsId',login.mandatory,TransactionsController.getAllTransactionsId);
router.post('/getAllTransactionsFixed',login.mandatory,TransactionsController.getAllTransactionsFixed);
router.post('/getPaymentType',login.mandatory,TransactionsController.getPaymentType);
router.post('/createTransaction',login.mandatory,cpUpload,TransactionsController.createTransaction);
router.post('/updateStatus',login.mandatory,TransactionsController.updateStatus);
router.post('/updateMoviment',login.mandatory,TransactionsController.updateMoviment);
router.post('/deleteTransaction',login.mandatory,TransactionsController.deleteTransaction);
router.post('/updateMovimentDuo',login.mandatory,TransactionsController.updateMovimentDuo);
router.post('/sendMessageSigle',TransactionsController.sendMessageSigle);
router.get('/sendMessageDayPayment',TransactionsController.sendMessageDayPayment);

router.post('/getMessageId',TransactionsController.getMessageId);
router.post('/updateMessage',TransactionsController.updateMessage);
router.post('/deleteMessage',TransactionsController.deleteMessage);


module.exports = router;