const express = require('express');
const router = express.Router();
const UsersController = require('../../controllers/app-module/user-controller');
const login = require('../../middleware/login');

router.post('/register', UsersController.createUser);
router.post('/login',UsersController.login);
router.post('/address',login.mandatory,UsersController.createOrUpdateAddress);
router.post('/typeUser',login.mandatory,UsersController.updateTypeUser);
router.post('/updateToken',UsersController.updateToken);
router.post('/updateSingle',login.mandatory,UsersController.updateSingle);
router.post('/updatePassword',login.mandatory,UsersController.updatePassword);
router.post('/resetPassword',UsersController.resetPassword);
router.post('/updateResetPassword',UsersController.updateResetPassword);
router.post('/addressRegister',UsersController.createOrUpdateAddress);
router.get('/getUrlAppStores',UsersController.getUrlAppStores);
router.post('/excludeUserId',UsersController.excludeUserId);
router.post('/registerUser',login.mandatory,UsersController.registerUser);
router.get('/getAllUsers',login.mandatory,UsersController.getAllUsers);
router.get('/getTokenSms',login.mandatory,UsersController.getTokenSms);
router.post('/validatelogin',login.mandatory,UsersController.validatelogin);


//temporario
router.post('/updatePass',UsersController.updatePassword);

module.exports = router;